function yp = bpeaodefile(t,y,params);

S = y(1);
E = y(2);
Ev = y(3);
I = y(4);
Iv = y(5);
R = y(6);
H = y(7);
D = y(8);

betabar= params(1);
kappa = params(2);
zeta = params(3);
gamma = params(4);
sigma = params(5);
eta = params(6);
nu = params(7);
seasonalsize = params(8);
fatiguesize = params(9);
fatiguemean = params(10);
fatiguesig = params(11);
betabarv = params(12);
tv = params(13);
Evbar = params(14);
seasonalposition = params(15);
lambda = params(16);
xi = params(17);
mitigate = params(18);



    psi = seasonalsize*(cos((t+seasonalposition)*2*pi/365)-1)/2 - mitigate*(t>76).*(t<806)*0.5;
    kappa = kappa*(1 -normcdf(t,fatiguemean,fatiguesig))+fatiguesize*kappa*normcdf(t,fatiguemean,fatiguesig);





beta = betabar*exp(-kappa*nu*zeta*H+psi);
betav = betabarv*exp(-kappa*nu*zeta*H+psi);



x(1) = -beta*S*I - betav*S*Iv - (t>321)*lambda*S + xi*R;
x(2) = beta*S*I - sigma*E;
x(3) = betav*S*Iv - sigma*Ev + (t<(tv+2))*(t>tv)*Evbar;
x(4) = sigma*E - gamma*I;
x(5) = sigma*Ev - gamma*Iv;
x(6) = (1-nu)*zeta*H + (1-eta)*gamma*(I+Iv) -(t<(tv+2))*(t>tv)*Evbar +(t>321)*lambda*S - xi*R;
x(7) = eta*gamma*(I+Iv) - zeta*H;
x(8) = nu*zeta*H;

yp = transpose(x);